
DECLARE @ANIO AS INTEGER, @MES AS INTEGER, @DIA AS INTEGER
SELECT @ANIO = 2023, @MES = 12, @DIA = 6

SELECT T0.ANIO, T0.MES, T0.DIA, T0.HORA, T0.MINUTO, SUM(CANT) AS CANT 
FROM  (SELECT T1.ANIO, T1.MES, T1.DIA, T1.HORA, T1.MINUTO, COUNT(1) AS CANT
       FROM (SELECT DATEPART(YY, S.BEGIN_TIMESTAMP) AS ANIO,
                    DATEPART(MM, S.BEGIN_TIMESTAMP) AS MES, 
                    DATEPART(DD, S.BEGIN_TIMESTAMP) AS DIA, 
                    DATEPART(HH, S.BEGIN_TIMESTAMP) AS HORA, 
                    DATEPART(MI, S.BEGIN_TIMESTAMP) - (DATEPART(MI, S.BEGIN_TIMESTAMP) % 5) AS MINUTO
             FROM PSESSIONS_HISTORY S
             WHERE S.BEGIN_TIMESTAMP <> S.LAST_TIMESTAMP AND
                   DATEPART(YY, S.BEGIN_TIMESTAMP) = @ANIO AND
                   DATEPART(MM, S.BEGIN_TIMESTAMP) = @MES AND
                   DATEPART(DD, S.BEGIN_TIMESTAMP) = @DIA AND
                   DATEPART(YY, S.LAST_TIMESTAMP) = @ANIO AND
                   DATEPART(MM, S.LAST_TIMESTAMP) = @MES AND
                   DATEPART(DD, S.LAST_TIMESTAMP) = @DIA) T1
       GROUP BY T1.ANIO, T1.MES, T1.DIA, T1.HORA, T1.MINUTO 
       UNION ALL
       SELECT T3.ANIO, T3.MES, T3.DIA, T2.HORA, T2.MINUTO, COUNT(1) AS CANT 
       FROM (SELECT HORA, MINUTO 
             FROM (SELECT 0 AS MINUTO UNION
                   SELECT 5 AS MINUTO UNION
                   SELECT 10 AS MINUTO UNION
                   SELECT 15 AS MINUTO UNION
                   SELECT 20 AS MINUTO UNION
                   SELECT 25 AS MINUTO UNION
                   SELECT 30 AS MINUTO UNION
                   SELECT 35 AS MINUTO UNION
                   SELECT 40 AS MINUTO UNION
                   SELECT 45 AS MINUTO UNION
                   SELECT 50 AS MINUTO UNION
                   SELECT 55 AS MINUTO) M,
                  (SELECT 0 AS HORA UNION
                   SELECT 1 AS HORA UNION
                   SELECT 2 AS HORA UNION
                   SELECT 3 AS HORA UNION
                   SELECT 4 AS HORA UNION
                   SELECT 5 AS HORA UNION
                   SELECT 6 AS HORA UNION
                   SELECT 7 AS HORA UNION
                   SELECT 8 AS HORA UNION
                   SELECT 9 AS HORA UNION
                   SELECT 10 AS HORA UNION
                   SELECT 11 AS HORA UNION
                   SELECT 12 AS HORA UNION
                   SELECT 13 AS HORA UNION
                   SELECT 14 AS HORA UNION
                   SELECT 15 AS HORA UNION
                   SELECT 16 AS HORA UNION
                   SELECT 17 AS HORA UNION
                   SELECT 18 AS HORA UNION
                   SELECT 19 AS HORA UNION
                   SELECT 20 AS HORA UNION
                   SELECT 21 AS HORA UNION
                   SELECT 22 AS HORA UNION
                   SELECT 23 AS HORA) H) T2
             LEFT OUTER JOIN (SELECT DATEPART(YY, S.BEGIN_TIMESTAMP) AS ANIO,
                                     DATEPART(MM, S.BEGIN_TIMESTAMP) AS MES,
                                     DATEPART(DD, S.BEGIN_TIMESTAMP) AS DIA,
                                     DATEPART(HH, S.BEGIN_TIMESTAMP) AS BEGIN_HH,
                                     DATEPART(MI, S.BEGIN_TIMESTAMP) AS BEGIN_MI,
                                     DATEPART(HH, S.LAST_TIMESTAMP) AS LAST_HH,
                                     DATEPART(MI, S.LAST_TIMESTAMP) AS LAST_MI
                              FROM PSESSIONS_HISTORY S
                              WHERE S.BEGIN_TIMESTAMP <> S.LAST_TIMESTAMP AND
                                    DATEPART(YY, S.BEGIN_TIMESTAMP) = @ANIO AND
                                    DATEPART(MM, S.BEGIN_TIMESTAMP) = @MES AND
                                    DATEPART(DD, S.BEGIN_TIMESTAMP) = @DIA AND
                                    DATEPART(YY, S.LAST_TIMESTAMP) = @ANIO AND
                                    DATEPART(MM, S.LAST_TIMESTAMP) = @MES AND
                                    DATEPART(DD, S.LAST_TIMESTAMP) = @DIA) T3 
             ON ((T2.HORA * 100) + T2.MINUTO) > ((T3.BEGIN_HH * 100) + T3.BEGIN_MI) AND 
                ((T2.HORA * 100) + T2.MINUTO) <= ((T3.LAST_HH * 100) + T3.LAST_MI)
             WHERE T3.BEGIN_HH IS NOT NULL
             GROUP BY T3.ANIO, T3.MES, T3.DIA, T2.HORA, T2.MINUTO) T0
GROUP BY T0.ANIO, T0.MES, T0.DIA, T0.HORA, T0.MINUTO
ORDER BY T0.ANIO, T0.MES, T0.DIA, T0.HORA, T0.MINUTO